<?php 

define("BORDER",20);
define("SHADOW",15);
define("OFFSET",10);

header('Content-type: image/jpeg');

// Pobiera obraz
$filename = $_GET['photo'];

// Tworzy oznaczenie i nazw pliku po modyfikacji
$str = strtok($filename,".");
$newfile = $str . "mod.jpg";

// Odczytuje zmodyfikowany plik, jeli taki istnieje
if (file_exists($newfile)) {
    readfile($newfile);

} else { // Tworzy plik

   $im=imagecreatefromjpeg($filename);

   if (!$im) exit("not a JPEG image");

   // Oblicza wymiary nowego obrazu i rysuje go
   $width=imagesx($im);
   $height=imagesy($im);

   $newwidth=$width+(2*BORDER);
   $newheight=$height+(2*BORDER);
   $newimage=imagecreatetruecolor($newwidth,$newheight);

   // Tworzy prostokt wypeniony kolorem
   $white = imagecolorallocate($newimage, 255, 255, 255);
   imagefilledrectangle($newimage,0,0,$newwidth,$newheight,$white);

   // Kopiuje stary obraz do nowego obrazu
   imagecopy($newimage,$im,BORDER,BORDER,0,0,$width,$height);

   // Dodaje czarn obwdk
   $black = imagecolorallocate($newimage, 0, 0, 0);
   imagerectangle($newimage, 0,0,$newwidth-1, $newheight-1,$black);

   // Dodaje cie
   // Tworzy now kanw wypenion kolorem biaym
   $shadowimage = imagecreatetruecolor($newwidth+SHADOW, $newheight+SHADOW);
   imagefilledrectangle($shadowimage, 0, 0, $newwidth+SHADOW, $newheight+SHADOW, $white);

   //Otwiera plik z szablonem cienia i kopiuje jego zawarto do nowego obszaru roboczego
   $shadowimg = imagecreatefromjpeg("workingshadow.jpg");
   imagecopyresized($shadowimage,$shadowimg,OFFSET,OFFSET,0,0,$newwidth+OFFSET,$newheight+OFFSET, imagesx($shadowimg),imagesy($shadowimg));

   // Kopiuje zdjcie z dodanym obramowaniem
   imagecopy($shadowimage,$newimage,0,0,0,0,$newwidth,$newheight);

   // Obraca obraz
   $rotated = imagerotate($shadowimage, 15, 0xFFFFFF,0);

   // Obraz wynikowy
   imagejpeg($rotated);

   // Zapisuje obraz
   imagejpeg($rotated,$newfile,100);

   // Nieobowizkowe
   // czyszczenie pamici
   imagedestroy($newimage);
   imagedestroy($im);
   imagedestroy($shadowimage);
}
?>
